/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm;

import ibm.nways.jdm.GraphicComponent;
import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.GraphicHandler;
import ibm.nways.jdm.InsetWrapper;
import ibm.nways.jdm.common.Disposable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.ScrollPane;

public class GraphicPanel
extends Panel
implements Disposable {
    private ScrollPane scroller;
    private GraphicComponent selectedComponent;
    private Component graphicComponent;
    private Image offscreen;
    private InsetWrapper insetWrapper;

    public GraphicPanel(GraphicHandler graphicHandler, Component component) {
        this.graphicComponent = component;
        this.setLayout(new BorderLayout());
        this.insetWrapper = new InsetWrapper();
        this.insetWrapper.add(component);
        this.scroller = new ScrollPane();
        this.scroller.add(this.insetWrapper);
        this.add("Center", this.scroller);
    }

    public Component getGraphicComponent() {
        return this.graphicComponent;
    }

    public void invalidate() {
        super.invalidate();
        this.offscreen = null;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        if (this.offscreen == null) {
            if (this.getSize().width == 0 || this.getSize().height == 0) {
                return;
            }
            this.offscreen = this.createImage(this.getSize().width, this.getSize().height);
        }
        Graphics graphics2 = this.offscreen.getGraphics();
        graphics2.setClip(0, 0, this.getSize().width, this.getSize().height);
        super.paint(graphics2);
        graphics.drawImage(this.offscreen, 0, 0, null);
        graphics2.dispose();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.insetWrapper.getPreferredSize();
        dimension.height += this.scroller.getHScrollbarHeight();
        dimension.width += this.scroller.getVScrollbarWidth();
        return dimension;
    }

    public void deselectComponent() {
        if (this.selectedComponent != null) {
            ((GraphicContainer)this.selectedComponent.getParent()).setSelectedComponent(null);
            this.selectedComponent = null;
        }
    }

    public void selectComponent(GraphicComponent graphicComponent) {
        this.deselectComponent();
        this.selectedComponent = graphicComponent;
        ((GraphicContainer)this.selectedComponent.getParent()).setSelectedComponent(graphicComponent);
    }

    public void dispose() {
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            Component component = componentArray[n];
            if (component instanceof Disposable) {
                ((Disposable)((Object)component)).dispose();
            }
            ++n;
        }
        if (this.graphicComponent != null && this.graphicComponent instanceof Disposable) {
            ((Disposable)((Object)this.graphicComponent)).dispose();
        }
        this.removeAll();
    }

    public void reallyDispose() {
        this.dispose();
    }
}

